library(raster)

figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 4 - Oyster settlement plates/Figure components/'
csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 4 - Oyster settlement plates/CSV/'
ndviDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 4 - Oyster settlement plates/NDVI/'
AHNDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 4 - Oyster settlement plates/Hellegat AHN/'

# GPS Coordinate information
setwd(ndviDirectory)
NDVI = raster('g_Westerschelde_2016_NDVI_Hellegat.tif')
NDVI = extend(NDVI, extent(NDVI) + c(0,0,0,100))
NDVI[is.na(NDVI)] = 0
NDVIinset = crop(NDVI, extent(54530,  54800,376215, 3764325))

yPos = 376440
xPos = 55100
main = 'Hellegat'
xlim = c(54380,55270)
breaks = c(-0.16,0.1,1)
scaleBarxy = c(54430, 376590)

# --- Recalculate inundation frequency
setwd(AHNDirectory)
r = raster('m5_67fn1.tif')
r2 = raster('m5_67fn2.tif')
r3 = merge(r,r2)
r4 = crop(r3, NDVIinset)

d = read.csv('inundationDuration_perc.csv')
e = read.csv('elevation_cm.csv')
inundationFreq = d$V3
elevation.cm = e$V3
elevation.m = elevation.cm/100
M = as.matrix(r4)

i_row = 1
i_col = 1
inundFreqM = M
inundFreqM[] = NA
for(i_col in 1:dim(M)[2]){
  for(i_row in 1:dim(M)[1]){
    if(!is.na(M[i_row,i_col])){
      inundFreqM[i_row,i_col] = inundationFreq[which.min(abs(M[i_row,i_col] - elevation.m))]
    }
  }
}
inundFreqR = setExtent(raster(inundFreqM), ext = extent(r4))


# Hellegat's settlment plates -----------

colPallete = colorRampPalette(alpha(c('white',grey(0.35)),0.5))
colSeq = colPallete(3)

tiff('Figure 4b.tif', width = 15, height = 18, units = "cm", res = 300)

plot(NDVIinset, breaks = breaks, col = colSeq, bty = 'n',
     xaxt = 'n', yaxt = 'n', box = F, legend = F)
scaleBarxy = c(54700,376615)
scalebar(d = 50, label = '50 m', xy = scaleBarxy, cex = 1.4)
contour(inundFreqR, levels = seq(0,100, 10), add = T, vfont = c("sans serif", "bold"),
        labcex = 1.2, col = alpha('black',1), lwd = 1.1, lty = 3)

setwd(csvDirectory)
d = read.csv('Oyster settlement plates.csv')
totalbiomass.g = as.numeric(tapply(d$biomass.g,d$inun,sum))
inundFreq = as.numeric(tapply(d$inun,d$inun,unique))
cageArea.m2 = as.numeric(tapply(d$area, d$inun, sum))
massDensity.g_m2 = totalbiomass.g/cageArea.m2
y = as.numeric(tapply(d$lat,d$inun,unique))
x = as.numeric(tapply(d$lon,d$inun,unique))

pointScaleParameter = 10
pointScale = sqrt(massDensity.g_m2/pointScaleParameter)
points(y ~ x, cex = pointScale, pch = 22, bg = alpha('red',0.5), col = 'darkred')
points(y[massDensity.g_m2 == 0] ~ x[massDensity.g_m2 == 0], 
       pch = 4, cex = 1, col = 'darkred',font = 2, lwd = 2)


# Legend ---------
pointScaleParameter = 10
legendSeq = c(2,1,0)
pointLegend = sqrt(10^legendSeq/pointScaleParameter)
xPos = 54540
yPos = 376630
rect(xleft = xPos, xright = xPos + 80, ybottom = yPos - 110, ytop = yPos + 10, col = 'white')
offset = seq(34,95,length.out = 4)
points(x = rep(xPos + 20, times = 4), y = yPos - offset,
       cex = c(pointLegend,1),
       bg = alpha('red',0.5), col = 'darkred',
       pch = c(22,22,22,4))
points(x = xPos + 20, y = yPos - 95,
       pch = 4, cex = 1, col = 'darkred', lwd = 2)

text = rev(c(0,
         expression('10'^'0'),
         expression('10'^'1'),
         expression('10'^'2')))
offset = seq(34,95,length.out = 4)
text(x = xPos + 40, y = yPos - 7, expression(g/m^2), cex = 1.3)
text(x = rep(xPos + 60, times = 4), 
     y = yPos - offset, 
     cex = 1.3,
     text)
setwd(figureDirectory)
dev.off()



